﻿SET NOCOUNT ON 


declare @name nvarchar(255)
declare @dbid int
declare @cmptlevel tinyint
declare @SQLString	nvarchar(max)

IF OBJECT_ID('tempdb..##DBInfo') IS NOT NULL 
			DROP TABLE ##DBInfo ;

Create table ##DBInfo
(
[dbid]				int,
[Database]			nvarchar (120),
[File]				nvarchar (255),
[File State]		nvarchar (60),
[Collation]			nvarchar (255),
[File Size]			nvarchar (50),
[Used Size]			nvarchar (50),
[Percent Used]		nvarchar (50),
[Max Size]			nvarchar (50),
[Autoextend]		nvarchar (20),
[Recovery Model]	nvarchar (10),
[Compability Level] nvarchar (10)
)

insert into ##DBInfo
(
[dbid]
,[Database]
,[File]
,[Collation]
,[File Size]
,[Used Size]
,[Percent Used]
,[Max Size]
,[Autoextend]
,[Recovery Model]
,[Compability Level])

select 
sdb.dbid as [dbid]
,sdb.name as [Name]
,mf.name as [File]
,db.collation_name as [Collation]
, 0 [File Size]
,mf.file_id
,'0' as [Percent Used]
,CASE mf.max_size 
	WHEN -1 THEN N'Unlimitied'
	WHEN 268435456 THEN N'Unlimited'
	ELSE cast(mf.max_size as NVARCHAR)
 END as [Max Size]
,CASE is_percent_growth 
	WHEN 1 THEN (cast(mf.growth as nvarchar) + ' %') 
	WHEN 0 THEN CASE mf.growth
					WHEN 0 then 'Disabled'
					ELSE cast(mf.growth*8/1024 as nvarchar) + ' MB'
				END
	END AS [Autoexend]
,db.recovery_model_desc [Recovery Model]  
,sdb.cmptlevel [Compability Level]
FROM sys.sysdatabases sdb
join sys.databases db on sdb.dbid=db.database_id
join [sys].[master_files] mf on sdb.dbid=mf.database_id
where not db.state = '6'


-- Get database file Used Size. Loop trough all databases and update ##DBInfo table. 

declare curDB cursor for
select sdb.name,sdb.dbid,sdb.cmptlevel from sys.sysdatabases sdb
join sys.databases db on sdb.dbid=db.database_id
where not db.state = '6'

open curDB

Fetch next from curDB into
@name,@dbid,@cmptlevel

while @@FETCH_STATUS = 0
BEGIN

select @SQLString=N'use ' + quotename(@name) + N';
update ##DBInfo SET ##DBInfo.[File Size]=tmp.filesize, ##DBInfo.[Used Size]=tmp.SpaceUsed, ##DBInfo.[File State]=tmp.state_desc from 
	(Select name,(LEFT(convert(nvarchar(50),ROUND(fileproperty(name,''SpaceUsed'')/128.000,2)),
				 (LEN(convert(nvarchar(50),ROUND(fileproperty(name,''SpaceUsed'')/128.000,2)))-5))) As SpaceUsed,
				 state_desc as state_desc,
				 size*8.0/1024.0 as filesize
	From sys.database_files) tmp
	where tmp.name COLLATE SQL_Latin1_General_CP1_CI_AS = ##DBInfo.[File] COLLATE SQL_Latin1_General_CP1_CI_AS'

EXECUTE sp_executesql @SQLString;

Fetch next from curDB into
@name,@dbid,@cmptlevel

END
Close curDB
deallocate curDB

update ##DBInfo set [Percent Used] = convert(nvarchar(50),convert(decimal(10,2),convert(real,[Used Size])/convert(real,[File Size])*100)) + '%' 

--select * from ##DBInfo order by [Database]


declare @DBInfbody varchar(max)

set @DBInfbody = cast( (
select td = 		d.[Database]	+ '</td><td>' + 
			d.[File]		+ '</td><td>'  + 
			d.[File State]	+ '</td><td>'  + 
			d.[Collation]	+ '</td><td>' +
			d.[File Size]	+ '</td><td>' +
			d.[Used Size]	+ '</td><td>' +
			d.[Percent Used] + '</td><td>' +
			d.[Max Size]	+ '</td><td>' +
			d.[Autoextend]	+ '</td><td>' +
			d.[Recovery Model]		+ '</td><td>' +
			d.[Compability Level]	+ '</td>#'
from (
      select   [Database] 
               ,[File] 
               ,[File State] 
				,[Collation]
				,[File Size]
	       ,[Used Size]
	       ,[Percent Used]
	       ,[Max Size]
	       ,[Autoextend]
	       ,[Recovery Model]
	       ,[Compability Level]

      from ##DBInfo 
      ) as d order by [Database]
for xml path( 'tr' ), type ) as varchar(max) )

set @DBInfbody =  '<br><h4> Database Information </h4> <table cellpadding="2" cellspacing="2" border="1">'
              + '<tr><th>Database</th>
		 <th>File</th>
		 <th>File State</th>
		 <th>Collation</th>
		 <th>File Size</th>
		 <th>Used Size</th>
		 <th>Percent Used</th>
		 <th>Max Size</th>
		 <th>Autoextend</th>
		 <th>Recovery Model</th>
		 <th>Compability level</th></tr>'
              +  replace( replace( @DBInfbody, '&lt;', '<' ), '&gt;', '>' ) 
              +  '<table>'

-- Split data in sevral rows to fit SQLCMDB output buffer.

declare    @string NVARCHAR(MAX)
declare    @delimiter CHAR(1) 

IF OBJECT_ID('tempdb..#output') IS NOT NULL 
			DROP TABLE #output ;

create table #output
(
id int identity
,splitdata NVARCHAR(800)
) 
DECLARE	@start INT, @end INT 
set @delimiter='#'
set @string=@DBInfbody


SELECT @start = 1, @end = CHARINDEX(@delimiter, @string) 
WHILE @start < LEN(@string) + 1 BEGIN 
    IF @end = 0  
       SET @end = LEN(@string) + 1
       INSERT INTO #output (splitdata)
        VALUES(SUBSTRING(@string, @start, @end - @start)) 
        SET @start = @end + 1 
        SET @end = CHARINDEX(@delimiter, @string, @start)
END 

select splitdata COLLATE SQL_Latin1_General_CP1_CI_AS from #output order by id