﻿SET NOCOUNT ON 

--select 
--sj.[name]
--,sj.[description]
--,case sj.[notify_level_email]
--	when 0 then 'No' 
--	else 'Yes'
--	end as [Email operator configured]  
--,case sj.[notify_level_eventlog]
--	when 0 then 'No' 
--	else 'Yes'
--	end as [Eventlog operator configured] 
--,case sj.[notify_level_page]
--	when 0 then 'No' 
--	else 'Yes'
--	end as [Page operator configured]
--,case sj.[notify_level_netsend]
--	when 0 then 'No' 
--	else 'Yes'
--	end as [Netsend operator configured]
--from sysjobs as sj
--left outer join dbo.sysoperators so 
--on so.id=sj.notify_email_operator_id  


declare @alecnfbody varchar(max)

set @alecnfbody = cast( (
select td = d.[name] + '</td><td>' 
		  + d.[description]  + '</td><td>'  
		  + d.[Email operator configured] + '</td><td>' 
		  + d.[Eventlog operator configured] + '</td><td>' 
		  + d.[Page operator configured] + '</td><td>' 
		  + d.[Netsend operator configured] + '</td>#'
from (
      select 
			sj.[name]
			,sj.[description]
			,case sj.[notify_level_email]
				when 0 then 'No' 
				else 'Yes'
			end as [Email operator configured]  
			,case sj.[notify_level_eventlog]
				when 0 then 'No' 
				else 'Yes'
			end as [Eventlog operator configured] 
			,case sj.[notify_level_page]
				when 0 then 'No' 
				else 'Yes'
			end as [Page operator configured]
			,case sj.[notify_level_netsend]
				when 0 then 'No' 
				else 'Yes'
			end as [Netsend operator configured]
		from msdb.dbo.sysjobs as sj
		left outer join msdb.dbo.sysoperators so 
		on so.id=sj.notify_email_operator_id  
		) as d Order by [name]
for xml path( 'tr' ), type ) as varchar(max) )
set @alecnfbody = '<br><h4> SQL Server Alert Configuration </h4> <table cellpadding="2" cellspacing="2" border="1">'
              + '<tr><th>Job Name</th>
			  <th>Description</th>
			  <th>Email operator configured</th>
			  <th>Eventlog operator configured</th>
			  <th>Page operator configured</th>
			  <th>Netsend operator configured</th></tr>'
              + replace( replace( @alecnfbody, '&lt;', '<' ), '&gt;', '>' ) 
              + '<table>'



-- split string to fit sqlcmd output size.


declare    @string NVARCHAR(MAX)
declare    @delimiter CHAR(1) 

IF OBJECT_ID('tempdb..#output') IS NOT NULL 
			DROP TABLE #output ;

create table #output
(
id int identity 
,splitdata NVARCHAR(800)
) 

DECLARE	 @start INT, @end INT 
set @delimiter='#'
set @string=''
set @string= @alecnfbody


SELECT @start = 1, @end = CHARINDEX(@delimiter, @string) 
WHILE @start < LEN(@string) + 1 BEGIN 
    IF @end = 0  
       SET @end = LEN(@string) + 1
       INSERT INTO #output (splitdata)
        VALUES(SUBSTRING(@string, @start, @end - @start)) 
        SET @start = @end + 1 
        SET @end = CHARINDEX(@delimiter, @string, @start)
END 

select splitdata COLLATE SQL_Latin1_General_CP1_CI_AS from #output order by id

