﻿SET NOCOUNT ON 

--************************************
--** SQL Server Backup History      **
--************************************

IF OBJECT_ID('tempdb..#BackupInfo') IS NOT NULL 
			DROP TABLE #BackupInfo ;

Create table #BackupInfo
(
[Server]			nvarchar(255),
[FromDateTime]			nvarchar(23),
[ToDateTime]			nvarchar(23),
[Database Name]			nvarchar(255),
[Backup Type]			nvarchar(40),
[Backup Size MB]		nvarchar(40),
[Compressed backup size MB] 	nvarchar(40),
[Logical Device Name]		nvarchar(255),
[Physical Device Name]		nvarchar(255),

)

-- Check for backup information

insert into  #BackupInfo
([Server]
,[FromDateTime]
,[ToDateTime]
,[Database Name]
,[Backup Type]
,[Backup Size MB]
,[Compressed backup size MB]
,[Logical Device Name]
,[Physical Device Name]
)

(SELECT 
CONVERT(CHAR(100), SERVERPROPERTY('Servername')) AS Server, 
msdb.dbo.backupset.backup_start_date as FromDateTime, 
msdb.dbo.backupset.backup_finish_date as ToDateTime,
msdb.dbo.backupset.database_name as DatabaseName, 
CASE msdb..backupset.type 
	WHEN 'D' THEN 'Database' 
	WHEN 'L' THEN 'Log' 
	WHEN 'I' THEN 'Differential Database'
	WHEN 'F' THEN 'File or Filegroup'
	WHEN 'G' THEN 'Differential file'
	WHEN 'P' THEN 'Partial'
	WHEN 'Q' THEN 'Differential partial'
	ELSE 'Undefined'
END AS backup_type, 
LEFT(convert(nvarchar(50),msdb.dbo.backupset.backup_size/1024),LEN(convert(nvarchar(50),msdb.dbo.backupset.backup_size/1024))-7) as [BackupSize MB], 
LEFT(convert(nvarchar(50),msdb.dbo.backupset.[compressed_backup_size]/1024),LEN(convert(nvarchar(50),msdb.dbo.backupset.[compressed_backup_size]/1024))-7) as [compressed backup size MB], 
msdb.dbo.backupmediafamily.logical_device_name, 
msdb.dbo.backupmediafamily.physical_device_name
FROM msdb.dbo.backupmediafamily 
INNER JOIN msdb.dbo.backupset ON msdb.dbo.backupmediafamily.media_set_id = msdb.dbo.backupset.media_set_id 
WHERE (msdb..backupset.type in ('D','F','P') and CONVERT(datetime, msdb.dbo.backupset.backup_start_date, 102) >= GETDATE() - 14) 
   or (msdb..backupset.type in ('L','I','G','Q') and CONVERT(datetime, msdb.dbo.backupset.backup_start_date, 102) >= GETDATE() - 1)
)

-- Check for databases with no backup at all.

insert into  #BackupInfo
([Server]
,[FromDateTime]
,[ToDateTime]
,[Database Name]
,[Backup Type]
,[Backup Size MB]
,[Compressed backup size MB]
,[Logical Device Name]
,[Physical Device Name]
)

(SELECT 
CONVERT(CHAR(100), SERVERPROPERTY('Servername')) AS Server, 
'N/A', 
'N/A',
sysdb.name, 
'No Backup', 
'0', 
'0', 
'N/A', 
'N/A'
FROM sys.[sysdatabases] as sysdb
where sysdb.name not in (select [Database Name] from #BackupInfo)

)

--select * from #BackupInfo
-- Create HTML output --
declare @bakinfbody varchar(max)

set @bakinfbody = cast( (
select   td= '#' +
			 ltrim(rtrim(d.[Database Name])) + '</td><td>'  + 
			 ltrim(rtrim(d.FromDateTime)) + '</td><td>'  + 
			 ltrim(rtrim(d.ToDateTime))  + '</td><td>'  + 
			 ltrim(rtrim(d.[Backup Type]))+ '</td><td>'  + 
			 ltrim(rtrim(d.[Backup Size MB])) + '</td><td>'  + 
			 ltrim(rtrim(d.[Compressed backup size MB])) + '</td><td>'  + 
			 ltrim(rtrim(Isnull(d.[Logical Device Name],'N/A'))) + '</td><td>'  + 
			 ltrim(rtrim(isnull(d. [Physical Device Name],'N/A')))  + '</td>'
from (
      select    [Database Name] as [Database Name]
			   ,[FromDateTime]	as FromDateTime
               ,[ToDateTime]	as ToDateTime
			   ,[Backup Type]	as [Backup Type]
			   ,[Backup Size MB]			as [Backup Size MB]
			   ,[Compressed backup size MB] as [Compressed backup size MB] 
			   ,[Logical Device Name]		as [Logical Device Name]
			   ,[Physical Device Name]		as [Physical Device Name] 
      from #BackupInfo
      ) as d order by [Database Name], [FromDateTime]
for xml path( 'tr' ), type ) as varchar(max) )

set @bakinfbody ='<br><h4> SQL Server Backup Information </h4>' + '<table cellpadding="2" cellspacing="2" border="1">'
              + '<tr><th>Database Name</th>
			  <th>FromDateTime</th>
			  <th>ToDateTime</th>
			  <th>Backup Type</th>
			  <th>Backup Size MB</th>
			  <th>Compressed Backup Size MB</th>
			  <th>Logical Device Name</th>
			  <th>Physical Device Name</th></tr>'
              + replace( replace( @bakinfbody, '&lt;', '<' ), '&gt;', '>' ) 
			  + '<table>'
			  	

-- split string to fit sqlcmdb output size.


declare    @string NVARCHAR(MAX)
declare    @delimiter CHAR(1) 

IF OBJECT_ID('tempdb..#output') IS NOT NULL 
			DROP TABLE #output ;

create table #output
(
id int identity 
,splitdata NVARCHAR(800)
) 

DECLARE	 @start INT, @end INT 
set @delimiter='#'
set @string=''
set @string=@bakinfbody


SELECT @start = 1, @end = CHARINDEX(@delimiter, @string) 
WHILE @start < LEN(@string) + 1 BEGIN 
    IF @end = 0  
       SET @end = LEN(@string) + 1
       INSERT INTO #output (splitdata)
        VALUES(SUBSTRING(@string, @start, @end - @start)) 
        SET @start = @end + 1 
        SET @end = CHARINDEX(@delimiter, @string, @start)
END 

select splitdata COLLATE SQL_Latin1_General_CP1_CI_AS from #output order by id