﻿SET NOCOUNT ON 

--SELECT
--    [ReadLatency] =
--        CASE WHEN [num_of_reads] = 0
--            THEN 0 ELSE ([io_stall_read_ms] / [num_of_reads]) END,
--    [WriteLatency] =
--        CASE WHEN [num_of_writes] = 0
--            THEN 0 ELSE ([io_stall_write_ms] / [num_of_writes]) END,
--    [Latency] =
--        CASE WHEN ([num_of_reads] = 0 AND [num_of_writes] = 0)
--            THEN 0 ELSE ([io_stall] / ([num_of_reads] + [num_of_writes])) END,
--    [AvgBPerRead] =
--        CASE WHEN [num_of_reads] = 0
--            THEN 0 ELSE ([num_of_bytes_read] / [num_of_reads]) END,
--    [AvgBPerWrite] =
--        CASE WHEN [num_of_writes] = 0
--            THEN 0 ELSE ([num_of_bytes_written] / [num_of_writes]) END,
--    [AvgBPerTransfer] =
--        CASE WHEN ([num_of_reads] = 0 AND [num_of_writes] = 0)
--            THEN 0 ELSE
--                (([num_of_bytes_read] + [num_of_bytes_written]) /
--                ([num_of_reads] + [num_of_writes])) END,
--    LEFT ([mf].[physical_name], 2) AS [Drive],
--    DB_NAME ([vfs].[database_id]) AS [DB],
--	mf.type_desc,
--    [mf].[physical_name]
--FROM
--    sys.dm_io_virtual_file_stats (NULL,NULL) AS [vfs]
--	JOIN sys.master_files AS [mf]
--    ON [vfs].[database_id] = [mf].[database_id]
--    AND [vfs].[file_id] = [mf].[file_id]
--ORDER BY [WriteLatency] DESC;
--GO



declare @DBfileinfbody varchar(max)

set @DBfileinfbody = cast( (
select td = d.[DB]									+ '</td><td>' 
		  + cast(d.[ReadLatency] as varchar(30))	+ '</td><td>' 
		  + cast(d.[WriteLatency] as varchar(30))	+ '</td><td>'  
		  + cast(d.[Latency] as varchar(30))		+ '</td><td>' 
		  + cast(d.[AvgBPerRead] as varchar(30))	+ '</td><td>' 
		  + cast(d.[AvgBPerWrite] as varchar(30))	+ '</td><td>' 
		  + cast(d.[AvgBPerTransfer] as varchar(30))	+ '</td><td>'
		  + d.[Drive]			+ '</td><td>'
		  + d.[type_desc]		+ '</td><td>'
		  + d.[physical_name]	+ '</td>#'
from (
      SELECT
    [ReadLatency] =
        CASE WHEN [num_of_reads] = 0
            THEN 0 ELSE ([io_stall_read_ms] / [num_of_reads]) END,
    [WriteLatency] =
        CASE WHEN [num_of_writes] = 0
            THEN 0 ELSE ([io_stall_write_ms] / [num_of_writes]) END,
    [Latency] =
        CASE WHEN ([num_of_reads] = 0 AND [num_of_writes] = 0)
            THEN 0 ELSE ([io_stall] / ([num_of_reads] + [num_of_writes])) END,
    [AvgBPerRead] =
        CASE WHEN [num_of_reads] = 0
            THEN 0 ELSE ([num_of_bytes_read] / [num_of_reads]) END,
    [AvgBPerWrite] =
        CASE WHEN [num_of_writes] = 0
            THEN 0 ELSE ([num_of_bytes_written] / [num_of_writes]) END,
    [AvgBPerTransfer] =
        CASE WHEN ([num_of_reads] = 0 AND [num_of_writes] = 0)
            THEN 0 ELSE
                (([num_of_bytes_read] + [num_of_bytes_written]) /
                ([num_of_reads] + [num_of_writes])) END,
    LEFT ([mf].[physical_name], 2) AS [Drive],
    DB_NAME ([vfs].[database_id]) AS [DB],
	mf.type_desc,
    [mf].[physical_name]
FROM
    sys.dm_io_virtual_file_stats (NULL,NULL) AS [vfs]
	JOIN sys.master_files AS [mf]
    ON [vfs].[database_id] = [mf].[database_id]
    AND [vfs].[file_id] = [mf].[file_id]
) as d
ORDER BY [DB] DESC
for xml path( 'tr' ), type ) as varchar(max) )


set @DBfileinfbody = '<table cellpadding="2" cellspacing="2" border="1">'
              + '<tr><th>Database</th>
			  <th>ReadLatency</th>
			  <th>WriteLatency</th>
			  <th>Latency</th>
			  <th>AvgBPerRead</th>
			  <th>AvgBPerWrite</th>
			  <th>AvgBPertransfer</th>
			  <th>Drive</th>
			  <th>Type</th>
			  <th>Physical name</th></tr>'
              + replace( replace( @DBfileinfbody, '&lt;', '<' ), '&gt;', '>' ) 
              + '<table>'

set @DBfileinfbody= '<br><h4> Database File IO </h4>' + @DBfileinfbody


-- Split data in sevral rows to fit SQLCMD output buffer.

declare    @string NVARCHAR(MAX)
declare    @delimiter CHAR(1) 

IF OBJECT_ID('tempdb..#output') IS NOT NULL 
			DROP TABLE #output ;

create table #output
(
id int identity
,splitdata NVARCHAR(800)
) 

DECLARE	   @start INT, @end INT 
set @delimiter='#'
set @string=@DBfileinfbody


SELECT @start = 1, @end = CHARINDEX(@delimiter, @string) 
WHILE @start < LEN(@string) + 1 BEGIN 
    IF @end = 0  
       SET @end = LEN(@string) + 1
       INSERT INTO #output (splitdata)
        VALUES(SUBSTRING(@string, @start, @end - @start)) 
        SET @start = @end + 1 
        SET @end = CHARINDEX(@delimiter, @string, @start)
END 

select splitdata COLLATE SQL_Latin1_General_CP1_CI_AS from #output order by id