﻿SET NOCOUNT ON 

IF OBJECT_ID('tempdb..#SQLCheck') IS NOT NULL 
			DROP TABLE #SQLCheck ;

Create table #SQLCheck
( ID		int,
  GRPName	varchar(255),
  OBJName	varchar(255),
  CNTName	Varchar(255),
  CNTValue  Varchar(255)
 )

declare @GRPName		varchar(255)
declare @SQLServerVer	varchar(20)
declare @SQLString		nvarchar(500)

select  @SQLServerVer = (SELECT CONVERT (varchar, SERVERPROPERTY('ProductVersion')))

declare @TestType as varchar(255)
Select @TestType = 'Summary' -- Summary, Complete

-- ********************** 
-- ** Test Information ** 
-- ********************** 
 select @GRPName='Test Information'
 insert into #SQLCheck (ID,GRPName,OBJName,CNTName,CNTValue) values(10, @GRPName, 'Copyright','Company', 'Tieto')
 insert into #SQLCheck (ID,GRPName,OBJName,CNTName,CNTValue) values(20, @GRPName, 'Test','Date', getdate())
 insert into #SQLCheck (ID,GRPName,OBJName,CNTName,CNTValue) values(30, @GRPName, 'Test','Type', @TestType)
 
-- ********************************
-- ** Windows Server Information ** 
-- ********************************
 select @GRPName='Windows Server Information'
 
 insert into #SQLCheck (ID,GRPName,OBJName,CNTName,CNTValue) values(90, @GRPName, 'ServerProperty', 'ComputerNamePhysicalNetBIOS',	(SELECT CONVERT (varchar, SERVERPROPERTY('ComputerNamePhysicalNetBIOS'))))
 insert into #SQLCheck (ID,GRPName,OBJName,CNTName,CNTValue) values(105, @GRPName, 'ServerProperty', 'CPU_Count',(Select CPU_Count as [CPU Count] from sys.dm_os_sys_info))
 insert into #SQLCheck (ID,GRPName,OBJName,CNTName,CNTValue) values(105, @GRPName, 'ServerProperty', 'hyperthread_ratio',(Select hyperthread_ratio as hyperthreadratio from sys.dm_os_sys_info))
 if ((SELECT COUNT(*) FROM sys.dm_exec_connections where net_transport='TCP') > 0)
	BEGIN 
		insert into #SQLCheck (ID,GRPName,OBJName,CNTName,CNTValue) values(105, @GRPName, 'ServerProperty', 'IP address',cast (( SELECT deconn.[local_net_address] FROM sys.dm_exec_connections deconn join sys.tcp_endpoints te on te.endpoint_id=deconn.endpoint_id where net_transport='TCP' and cast(deconn.client_net_address  as varchar) <> cast(deconn.local_net_address as varchar) and deconn.endpoint_id=(Select endpoint_id from sys.tcp_endpoints where name='TSQL Default TCP') group by deconn.[local_net_address]) AS nvarchar) )
		insert into #SQLCheck (ID,GRPName,OBJName,CNTName,CNTValue) values(105, @GRPName, 'ServerProperty', 'Local TCP port',cast ((SELECT deconn.[local_tcp_port] FROM sys.dm_exec_connections deconn join sys.tcp_endpoints te on te.endpoint_id=deconn.endpoint_id where net_transport='TCP' and cast(deconn.client_net_address  as varchar) <> cast(deconn.local_net_address as varchar) and deconn.endpoint_id=(Select endpoint_id from sys.tcp_endpoints where name='TSQL Default TCP') group by deconn.[local_tcp_port]) AS nvarchar) )
	END
 ELSE
	BEGIN
		insert into #SQLCheck (ID,GRPName,OBJName,CNTName,CNTValue) values(105, @GRPName, 'ServerProperty', 'IP address', N'No TCP/IP connections exists')
	END
 IF ((select left(@SQLServerVer,2)) > 10)
 begin
    select  @SQLString='insert into #SQLCheck (ID,GRPName,OBJName,CNTName,CNTValue) values(105,''' +  @GRPName + ''', ''ServerProperty'', ''physical_memory MB'',(Select physical_memory_kb/1024 as [Physical_Memory MB] from sys.dm_os_sys_info))'
	EXECUTE sp_executesql @SQLString;
 end	
 else
 Begin
    select  @SQLString='insert into #SQLCheck (ID,GRPName,OBJName,CNTName,CNTValue) values(105,''' + @GRPName + ''', ''ServerProperty'', ''physical_memory MB'',(Select physical_memory_in_bytes/1048576 as [Physical_Memory MB] from sys.dm_os_sys_info))'
	EXECUTE sp_executesql @SQLString;
 END   

-- **************************** 
-- ** SQL Server information ** 
-- **************************** 

 select @GRPName='SQL Server Information'

 insert into #SQLCheck (ID,GRPName,OBJName,CNTName,CNTValue) values(40, @GRPName,  'ServerProperty', 'ServerName',(SELECT CONVERT (varchar, SERVERPROPERTY('ServerName'))))
 insert into #SQLCheck (ID,GRPName,OBJName,CNTName,CNTValue) values(50, @GRPName,  'ServerProperty', 'Edition',(SELECT CONVERT (varchar, SERVERPROPERTY('Edition'))))
 insert into #SQLCheck (ID,GRPName,OBJName,CNTName,CNTValue) values(60, @GRPName,  'ServerProperty', 'ProductVersion',(SELECT CONVERT (varchar, SERVERPROPERTY('ProductVersion'))))
 insert into #SQLCheck (ID,GRPName,OBJName,CNTName,CNTValue) values(70, @GRPName,  'ServerProperty', 'ProductLevel',(SELECT CONVERT (varchar, SERVERPROPERTY('ProductLevel'))))
 insert into #SQLCheck (ID,GRPName,OBJName,CNTName,CNTValue) values(80, @GRPName,  'ServerProperty', 'Collation',(SELECT CONVERT (varchar, SERVERPROPERTY('Collation'))))
 insert into #SQLCheck (ID,GRPName,OBJName,CNTName,CNTValue) values(100, @GRPName, 'ServerProperty','IsIntegratedSecurityOnly',(SELECT CASE (CONVERT (varchar, SERVERPROPERTY('IsIntegratedSecurityOnly'))) WHEN 0 THEN 'Not Integrated Security' when 1 then 'Integrated Security' else 'Not defined' END ))
 insert into #SQLCheck (ID,GRPName,OBJName,CNTName,CNTValue) values(110, @GRPName, 'ServerProperty','IsClustered',(SELECT CASE (CONVERT (varchar, SERVERPROPERTY('IsClustered')))				 WHEN 0 THEN 'Not Clustered' when 1 then  'Clustered' else 'Not defined' END ))
 insert into #SQLCheck (ID,GRPName,OBJName,CNTName,CNTValue) values(120, @GRPName, 'Sys.configurations','Maximum size of server memory (MB)',(SELECT convert(varchar(255),value) FROM [sys].[configurations] WHERE name='max server memory (MB)'))
 insert into #SQLCheck (ID,GRPName,OBJName,CNTName,CNTValue) values(130, @GRPName, 'Sys.configurations','Minimum size of server memory (MB)',(SELECT convert(varchar(255),value) FROM [sys].[configurations] WHERE name='min server memory (MB)'))
 insert into #SQLCheck (ID,GRPName,OBJName,CNTName,CNTValue) values(140, @GRPName, 'Sys.configurations','Enable compression of backups by default',(SELECT CASE value when 0 THEN 'Backup compression not enabled' when 1 then 'Backup compression enabled' else 'Not defined' END FROM [sys].[configurations] WHERE name='backup compression default'))



-- Create HTML output --

declare @tstinfbody varchar(max)
declare @winsrvinfbody varchar(max)
declare @sqlsrvinfbody varchar(max)
declare @allinf varchar(max)

set @tstinfbody = cast((
select  CNTName + ':	' + CNTValue + '<br> ' 
from (
      select    CNTName
               ,CNTValue  
      from #SQLCheck
	  where GRPName='Test Information'
      ) as d
for xml path( '' ), type ) as varchar(max) )
set @tstinfbody= replace( replace( @tstinfbody, '&lt;', '<' ), '&gt;', '>' ) 
set @tstinfbody= '<br><h4> Test Information </h4> ' + @tstinfbody
--print @tstinfbody

set @winsrvinfbody= cast((
select  CNTName + ':	' + CNTValue + '<br> ' 
from (
      select    CNTName
               ,CNTValue  
      from #SQLCheck
	  where GRPName='Windows Server Information'
      ) as d
for xml path( '' ), type ) as varchar(max) )
set @winsrvinfbody= replace( replace( @winsrvinfbody, '&lt;', '<' ), '&gt;', '>' ) 
set @winsrvinfbody= '<h4> Windows Server Information </h4> ' + @winsrvinfbody
--print @winsrvinfbody

set @sqlsrvinfbody= cast((
select  CNTName + ':	' + CNTValue + '<br> ' 
from (
      select    CNTName
               ,CNTValue  
      from #SQLCheck
	  where GRPName='SQL Server Information'
      ) as d
for xml path( '' ), type ) as varchar(max) )
set @sqlsrvinfbody= replace( replace( @sqlsrvinfbody, '&lt;', '<' ), '&gt;', '>' ) 
set @sqlsrvinfbody= '<h4> SQL Server Information </h4>' + @sqlsrvinfbody
--print @sqlsrvinfbody

set @allinf=@tstinfbody + @winsrvinfbody +@sqlsrvinfbody
print @allinf



