﻿SET NOCOUNT ON 


--***********************
--** SQL Server Health **
--***********************

declare @name nvarchar(255)
declare @dbid int
declare @SQLString		nvarchar(max)

IF OBJECT_ID('tempdb..##DBStats') IS NOT NULL 
			DROP TABLE ##DBStats ;

Create table ##DBStats
(
[dbid]						int,
[Database]					nvarchar (120),
[LastStatisticsDate]		nvarchar (20),
[LastDBCCRunDate]			nvarchar (20)
)

insert into ##DBStats
(
[dbid]
,[Database]
)
select 
sdb.dbid as [dbid]
,sdb.name as [Name]
FROM sys.sysdatabases sdb
join sys.databases db on sdb.dbid=db.database_id
where not db.state = '6'

declare curDB2 cursor for
select sdb.name,sdb.dbid from sys.sysdatabases sdb
join sys.databases db on sdb.dbid=db.database_id
where not db.state = '6'

open curDB2

Fetch next from curDB2 into
@name,@dbid

while @@FETCH_STATUS = 0
BEGIN

select @SQLString=N'
use ' + quotename(@name) + N';
update ##DBStats  SET ##DBStats.[LastStatisticsDate]=tmp.StatisticUpdateDate from 
	(SELECT ''' + @name + N''' as name, MAX(isnull(STATS_DATE([object_id], [stats_id]),''1900-01-01'')) AS [StatisticUpdateDate]
FROM sys.stats) tmp 
where tmp.name COLLATE SQL_Latin1_General_CP1_CI_AS = ##DBStats.[Database] COLLATE SQL_Latin1_General_CP1_CI_AS

'

EXECUTE sp_executesql @SQLString;

select @SQLString=
N'
Declare @logs table
(
LogDate DATETIME,
ProcessInfo VARCHAR(255),
Text VARCHAR(MAX)
);

insert into @logs 
exec sp_readerrorlog 0,1,''DBCC CHECKDB'', ''' + @name + N'''

update ##DBStats set ##DBStats.LastDBCCRunDate= tmp.LastDBCCRunDate from 
		(select ''' + @name + N''' as name, max(LogDate) as LastDBCCRunDate from @logs) tmp
		where tmp.name COLLATE SQL_Latin1_General_CP1_CI_AS = ##DBStats.[Database] COLLATE SQL_Latin1_General_CP1_CI_AS'

	
EXECUTE sp_executesql @SQLString;

Fetch next from curDB2 into
@name,@dbid

END
Close curDB2
deallocate curDB2

-- Create HTML output --

declare @DBStatsbody varchar(max)

set @DBStatsbody = cast( (
select td = d.[Database] + '</td><td>' + 
			cast(ISNULL(d.lastStatisticsDate,'N/A') as varchar(30))  + '</td><td>'  + 
			cast(ISNULL(d.LastDBCCRunDate,'N/A') as varchar(30)) + '</td>#' 
from (
      select   [Database] as [Database]
               ,LastStatisticsDate as lastStatisticsDate
               ,LastDBCCRunDate as LastDBCCRunDate
      from ##DBStats
      ) as d order by [Database]
for xml path( 'tr' ), type ) as varchar(max) )
set @DBStatsbody = '<br><h4> Database Maintenance </h4> <table cellpadding="2" cellspacing="2" border="1">'
              + '<tr><th>Database</th>
			  <th>LastStatisticsDate</th>
			  <th>LastDBCCRunDate</th></tr>'
              + replace( replace( @DBStatsbody, '&lt;', '<' ), '&gt;', '>' ) 
              + '<table>'

-- split string to fit sqlcmd output size.

declare    @string NVARCHAR(MAX)
declare    @delimiter CHAR(1) 

IF OBJECT_ID('tempdb..#output') IS NOT NULL 
			DROP TABLE #output ;

create table #output
(
id int identity 
,splitdata NVARCHAR(800)
) 

DECLARE	 @start INT, @end INT 
set @delimiter='#'
set @string=''
set @string=@DBStatsbody


SELECT @start = 1, @end = CHARINDEX(@delimiter, @string) 
WHILE @start < LEN(@string) + 1 BEGIN 
    IF @end = 0  
       SET @end = LEN(@string) + 1
       INSERT INTO #output (splitdata)
        VALUES(SUBSTRING(@string, @start, @end - @start)) 
        SET @start = @end + 1 
        SET @end = CHARINDEX(@delimiter, @string, @start)
END 

select splitdata COLLATE SQL_Latin1_General_CP1_CI_AS from #output order by id




--sp_readerrorlog 0,1,'DBCC CHECKDB', 't4'


--Declare @logs table
--(
--LogDate DATETIME,
--ProcessInfo VARCHAR(255),
--Text VARCHAR(MAX)
--);

--insert into @logs 
--exec sp_readerrorlog 0,1,'DBCC CHECKDB', 't4'

--select '[t4]' as name, max(LogDate) as LastDBCCRunDate from @logs

--update ##DBStats set ##DBStats.LastDBCCRunDate= tmp.LastDBCCRunDate from 
--		(select '[t4]' as name, max(LogDate) as LastDBCCRunDate from @logs) tmp
--		where tmp.name COLLATE SQL_Latin1_General_CP1_CI_AS = ##DBStats.[Database] COLLATE SQL_Latin1_General_CP1_CI_AS

--select * from ##DBStats